/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SystemIdentifier
implements Serializable {
    private static final String TRACE_MASKT = "XSASSIDT";
    private static final String TRACE_MASKF = "XSASSIDF";
    private static final String TRACE_MASKD = "XSASSIDD";
    private static final String SYSTEM_IDENTIFIER = "ibm-system-identifier";
    private static final String MACHINE_TYPE = "ibm-machine-type";
    private static final String MACHINE_MODEL = "ibm-machine-model";
    private static final String SERIAL_NUMBER = "ibm-serial-number";
    private static final String LOGICAL_PARTITION = "ibm-logical-partition";
    private static final String VALIDATION_KEY = "ibm-validation-key";
    private static final String LAST_UPDATE_TIMESTAMP = "last-update_TIMESTAMP";
    public static final String DEFAULT_LPAR = "0";
    public String machineType;
    public String machineModel;
    public String serialNumber;
    private transient String validationKey;
    public Date lastUpdateTimestamp;
    public String logicalPartition;
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String SECRET_KEY = "d00da49f43e406b2231aae69d36afe44d6ae4cfbf5e142b8cad3db8c57d82b3199e624e26a0ce693d892967e9b8defce2e816c7bab31b175add88aa287190154";

    public SystemIdentifier(String machineType, String serialNumber, Date lastUpdateTimestamp) {
        this(machineType, null, serialNumber, null, lastUpdateTimestamp);
        Trace.trace(TRACE_MASKT, "<> SystemIdentifier.SystemIdentifier(machineType=" + machineType + ", " + "serialNumber=" + serialNumber + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public SystemIdentifier(String machineType, String machineModel, String serialNumber, String logicalPartition, Date lastUpdateTimestamp) {
        this.machineType = machineType;
        this.machineModel = machineModel;
        this.serialNumber = serialNumber;
        this.logicalPartition = logicalPartition;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        Trace.trace(TRACE_MASKT, "<> SystemIdentifier.SystemIdentifier(machineType=" + machineType + ", " + "machineModel=" + machineModel + ", " + "serialNumber=" + serialNumber + ", " + "logicalPartition=" + logicalPartition + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public String toXml() {
        Trace.trace(TRACE_MASKT, "-> SystemIdentifier.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append("ibm-system-identifier ");
        buffer.append("ibm-machine-type=\"" + SasUtil.convert4Xml(this.machineType) + "\"");
        if (this.machineModel != null && this.machineModel.length() != 0) {
            buffer.append(" ");
            buffer.append("ibm-machine-model=\"" + SasUtil.convert4Xml(this.machineModel) + "\"");
        }
        buffer.append(" ");
        buffer.append("ibm-serial-number=\"" + SasUtil.convert4Xml(this.serialNumber) + "\"");
        if (this.logicalPartition != null && this.logicalPartition.length() > 0) {
            buffer.append(" ");
            buffer.append("ibm-logical-partition=\"" + SasUtil.convert4Xml(this.logicalPartition) + "\"");
        } else {
            buffer.append(" ");
            buffer.append("ibm-logical-partition=\"" + SasUtil.convert4Xml(DEFAULT_LPAR) + "\"");
        }
        if (this.validationKey != null && this.validationKey.length() > 0) {
            buffer.append(" ");
            buffer.append("ibm-validation-key=\"" + SasUtil.convert4Xml(this.generateValidationKey()) + "\"");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        buffer.append(" ");
        buffer.append("last-update_TIMESTAMP=\"" + SasUtil.convert4Xml(dateFormat.format(this.lastUpdateTimestamp)) + "\"");
        buffer.append("/>");
        Trace.trace(TRACE_MASKT, "<- SystemIdentifier.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> SystemIdentifier.clone()");
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- SystemIdentifier.clone()");
        return object;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> SystemIdentifier.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof SystemIdentifier) {
            SystemIdentifier systemIdentifier = (SystemIdentifier)object;
            if (this.machineType.equals(systemIdentifier.machineType) && this.machineModel.equals(systemIdentifier.machineModel) && this.serialNumber.equals(systemIdentifier.serialNumber) && this.logicalPartition.equals(systemIdentifier.logicalPartition) && this.validationKey.equals(systemIdentifier.validationKey) && this.lastUpdateTimestamp.equals(systemIdentifier.lastUpdateTimestamp)) {
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- SystemIdentifier.equals()");
        return result;
    }

    private static byte[] digest(String[] text, byte[] password) throws GeneralSecurityException {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        for (int i = 0; i < text.length; ++i) {
            sha.update(text[i].getBytes());
        }
        sha.update(password);
        return sha.digest();
    }

    private static String convertBytesToHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            int high = (block[i] & 0xF0) >> 4;
            int low = block[i] & 0xF;
            buf.append(HEX_CHARACTERS[high]);
            buf.append(HEX_CHARACTERS[low]);
        }
        return buf.toString();
    }

    private static byte[] convertHexToByteArray(String hexString) {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = (byte)Integer.parseInt(hexString.substring(i, i + 2), 16);
        }
        return bytes;
    }

    private String generateValidationKey() {
        this.validationKey = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            String[] values = new String[]{this.machineType, this.serialNumber, this.machineModel, this.logicalPartition, dateFormat.format(this.lastUpdateTimestamp)};
            byte[] digest = SystemIdentifier.digest(values, SystemIdentifier.convertHexToByteArray(SECRET_KEY));
            this.validationKey = SystemIdentifier.convertBytesToHexString(digest);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return this.validationKey;
    }
}

